/* 

Title: Wuji
Author: Steven Yi
Completed: March 28th, 2017

Description:
 
"Wuji" was written for the Eastman Mobile Acousmonium (EMA), "an ensemble of individual custom-built loudspeakers" that is a project developed out of the Eastman Audio Research Studio, lead by Oliver Schneller. The piece is designed for any number of available speakers spatially distributed in a room.  It is made up of multiple renderings of the primary single-channel source that is then mapped with one rendering per speaker. 

In writing for EMA, one of the sonic experiences that came mind were memories of performing in instrumental ensembles and sitting there on stage within a field of sound. It has been many years now since I last performed in an ensemble, but I remember that sound world as a unique and wonderful experience, one not easily reproduced by typical speaker setups that might surround the periphery of the listener. It is my hope that the listener experiences this work by not only being surrounded by the sound but also within it.  

Many thanks to Oliver Schneller and the members of EARS for the opportunity to compose for the EMA speaker ensemble. 

For more information about me and my work, please see my website: 

http://www.kunstmusik.com


*/
<CsoundSynthesizer>
<CsOptions>
</CsOptions>
<CsInstruments>

sr	= 44100	
ksmps	= 1	
nchnls	=	1
0dbfs	=	1

;; UDOs 
opcode adsr140_calc_coef,i,ii
  inum_samps, iratio xin
  xout exp( -log((1.0 + iratio) / iratio) / inum_samps)
endop

opcode alpha_adsr,a,iiii
  iatt,idec,isus, irel    xin 

  iatt_mult = 0
  iatt_base = 0
  if (iatt > 0) then
    iatt_mult = adsr140_calc_coef(iatt * sr, 0.3)
    iatt_base = (1.0 + 0.3) * (1 - iatt_mult)
  endif
  idec_mult = 0
  idec_base = 0
  if (idec > 0) then
    idec_mult = adsr140_calc_coef(idec * sr, 0.0001)
    idec_base = (isus - 0.0001) * (1.0 - idec_mult)
  endif
  irel_mult = 0
  irel_base = 0
  if (irel > 0) then
    irel_mult = adsr140_calc_coef(irel * sr, 0.0001)
    idec_base = -0.0001 * (1.0 - irel_mult)
  endif

  kv init (iatt > 0) ? 0 : 1
  kmode init (iatt > 0) ? 0 : 1
  krel release
  aout init 0

  kindx = 0

  if(krel == 1) then
    while (kindx < ksmps) do
      if(kv <= 0.001) then
        kv = 0
      else
        kv = irel_base +  (kv * irel_mult)
      endif

      aout[kindx] = kv
      kindx += 1
    od
  else
    while (kindx < ksmps) do
      if(kmode == 0) then
        kv = iatt_base + (kv * iatt_mult)

        if(kv >= 1) then
          kv = 1
          kmode = 1
          aout[kindx] = 1
        else 
          aout[kindx] = kv
        endif
      elseif(kmode == 1) then
        kv = idec_base + (kv * idec_mult)
        if (kv <= isus) then
          kv = isus
          kmode = 2
        endif
        aout[kindx] = kv
      else
        aout[kindx] = isus
      endif

      kindx += 1
    od
  endif

  xout  aout

endop

;; Bohlen-Pierce ET Scale
opcode bp,i,i
  ipch xin
  xout cpsxpch(ipch, 12, 3, 20)
endop


/* SOUND INSTRUMENTS */
instr 1	

  ifreq = p4 
  iamp  = p5

  asig = vco2(0.25, ifreq )
  /*asig += vco2(0.125, ifreq * 2, 10)*/
  asig = moogladder(asig, 1400, 0.2)
  asig *= alpha_adsr(p3 * .5, p3,0,p3) * iamp

  outc(asig, asig)

endin

instr chaotic
  kenv = oscili:k(0.5, 1 / p3, -1, 0.75) + 0.5
  /*kenv = oscili:k(0.5, 0.5 / p3)*/
  kpch = lfo:k(1, 0.5 + lfo:k(0.5, 14 / p3)) * kenv 
  asig = vco2(0.5, random(800, 1200) + 300 * kpch, 12)
  asig = moogladder(asig, 4000, 0)
  asig *= (0.125 + oscili:k(0.125, 1 / p3, -1, 0.75)) * p4 ;* expseg(1.0, p3 / 2, 1.0, p3 / 2, 0.0001) * 0.4 * p4
  outc(asig,asig)
endin

/*schedule("chaotic", 0, 62, 0.5)*/

/* PERFORMANCE INSTRUMENTS */
instr Ascending 
  ioct = p4
  idegree = p5
  imax = p6
  iamp = p7

  if(idegree < imax) then
    schedule  1, 0, p3, bp(ioct + idegree * .01), iamp
    schedule  1, 0, p3, bp(ioct + (idegree + 2) * .01), iamp
    schedule  "Ascending", p3, p3, ioct, idegree + 3, imax, iamp
  else
    if(iamp / 2 > 0.1) then
      schedule("Ascending", 0, random(8,13), 2, int(random(0,7)), 26, iamp / 2)
    else
      prints "Ascending Complete."
    endif
  endif
  turnoff
endin

instr Descending 
  ioct = p4
  idegree = p5
  imax = p6
  iamp = p7

  if(idegree > imax) then
    schedule 1, 0, p3, bp(ioct + idegree * .01), iamp
    schedule 1, 0, p3, bp(ioct + (idegree + 2) * .01), iamp
    schedule "Descending", p3, p3, ioct, idegree - 3, imax, iamp
  else
    if(iamp / 2 > 0.1) then
      schedule("Descending", 0, random(8,13), 2, int(random(26, 30)), int(random(1,6)), iamp / 2)
    else
      prints "Descending Complete."
    endif
  endif
  turnoff
endin


opcode play_chord,0,ii
  idur, iroot xin
  schedule(1, 0, idur, cps2pch(iroot, 12), 1)
  if(random:i(0,1) > 0.8) then
    ;; Octave + M3
    schedule(1, 0, idur, cps2pch(iroot, 12) * 2 * 5/4, 1) 
  endif
  if(random:i(0,1) > 0.6) then
    ;; P5
    schedule(1, 0, idur, cps2pch(iroot, 12) * 1.5, 1)
  endif
endop

instr end_performance
  prints "The End.\n"
  event_i("e", 0)
  turnoff
endin

instr chord_player
  iadd = p4 
  play_chord(20, 7 + int(random(0,3)))

  if(iadd > 0) then
    iaddNew = iadd * 2
    if(iaddNew > 8) then
      iaddNew = -8
    endif
  else
    iaddNew = iadd / 2 
    if(iaddNew > -2) then
      iaddNew = 2
    endif
  endif

print p2
  /*if(p2 > 340) then */
  if(p2 > 290) then 
    schedule("end_performance", 26, 1)
  else
    /*prints "iadd: %g\n", abs(iadd)*/
    schedule("chord_player", 20 + abs(iadd), 1, iaddNew)
  endif
  turnoff
endin

instr chaotic_player
  if (p4 > 0) then 
    schedule("chaotic", 0, 64, p5)
    schedule("chaotic_player", random(0.25, .4), 1, p4 - 1, p5)
  else
    if(p5 > 0.125) then
      /*prints "P5: %g\n", (p5 / 2)*/
      schedule("chaotic_player", random(58, 60), 1, 7, p5 / 2)
    endif
  endif
  turnoff
endin

instr start_performance
  schedule("Ascending", 0, random(8,13), 2, int(random(0,7)), 26, 0.5)
  schedule("Descending", 0, random(8,13), 2, int(random(26, 30)), int(random(1,6)), 0.5)
  schedule("chord_player",0, 1, 2) 
  schedule("chaotic_player", random(8,10), 1, 7, 0.5)
  turnoff
endin

/* PERFORMANCE CODE */
seed 0
;;schedule("start_performance", random(0, 4), 1)

#ifndef REPL
schedule("start_performance", 0, 1)
#endif

;;  schedule("chaotic_player", 0, 1, 7, 0.5)
</CsInstruments>
; ==============================================
<CsScore>
/* No score needed as orc will turn off rendering itself. */
/*i "Ascending" 0 3 1 0 39 */

</CsScore>
</CsoundSynthesizer>

